/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.animation;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.toma.gunsrpg.api.common.IWeaponConfig;
import dev.toma.gunsrpg.api.common.data.IAimInfo;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.common.item.guns.GunItem;
import lib.toma.animations.api.AnimationStage;
import lib.toma.animations.api.TickableAnimation;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Vector3f;

public class RecoilAnimation
extends TickableAnimation {
    private final float x;
    private final float y;
    private final float z;

    public RecoilAnimation(float x, float y, GunItem source, ItemStack data, IPlayerData provider) {
        super(3);
        IWeaponConfig config = source.getWeaponConfig();
        IAimInfo aimInfo = provider.getAimInfo();
        float modifier = aimInfo.isAiming() ? 0.2f + 0.8f * config.getRecoilAnimationScale() : 1.0f;
        this.x = x * modifier * source.getOpticalRecoilXY();
        this.y = y * modifier * source.getOpticalRecoilXY();
        this.z = 0.09f * modifier * 0.5f * source.getOpticalRecoilZ();
    }

    @Override
    public void animate(AnimationStage stage, MatrixStack matrixStack, IRenderTypeBuffer typeBuffer, int light, int overlay) {
        if (stage != AnimationStage.ITEM_AND_HANDS) {
            return;
        }
        float interpolated = this.getInterpolatedProgress();
        float progress = this.getPartial(interpolated);
        float xRot = this.x * progress;
        float yRot = this.y * progress;
        float zKick = this.z * progress;
        matrixStack.func_227861_a_(0.0, 0.0, (double)zKick);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(xRot));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(yRot));
    }

    private float getPartial(float progress) {
        return progress <= 0.5f ? progress / 0.5f : 1.0f - (progress - 0.5f) / 0.5f;
    }
}

